/*
 * Decompiled with CFR 0.152.
 */
package util.phylogenetics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import util.phylogenetics.InterruptTimerTask;

public class RunTreePrograms {
    public static void main(String[] args) {
        RunTreePrograms.runProgram("/home/frederic/Programs/RAxML/raxmlHPC-SSE3 -s /home/frederic/test/PolySeqOut_NoGenes_noInvar/polymorphisms_move.phy -w /home/frederic/test/PolySeqOut_NoGenes_noInvar -m GTRGAMMA -p 1234 -n inc1  -o S11 -f e -t /home/frederic/test/PolySeqOut_NoGenes_noInvar/inc1.tree", "", new File("/home/frederic/test/"), 5000L);
    }

    public static File runMaxPars(File alignmentPhy, File maxParsPath) {
        File out = new File(String.valueOf(alignmentPhy.toString().split("\\.")[0]) + ".tree");
        File outFolder = alignmentPhy.getParentFile();
        String command = maxParsPath.toString();
        RunTreePrograms.deleteConsenseFiles(outFolder);
        String input = alignmentPhy + "\nY\n";
        RunTreePrograms.runProgram(command, input, outFolder);
        File outtree = new File(outFolder + "/outtree");
        outtree.renameTo(out);
        return out;
    }

    public static void runPhyML(File in, File phymlPath, File parameters, int seed) {
        File outFolder = new File(in.getParent());
        if (!phymlPath.exists()) {
            System.err.println("Cannot find phyml executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        HashMap<String, Boolean> paraHM = RunTreePrograms.getParameters(parameters);
        String paraLine = RunTreePrograms.getParametersLine(parameters);
        String model = paraHM.containsKey("-m") ? "" : " -m GTR ";
        String seedString = paraHM.containsKey("--r_seed") ? "" : " --r_seed " + seed + " ";
        String bootstrap = paraHM.containsKey("-b") ? "" : " -b 0 ";
        String PhyMLcom = phymlPath + " -i " + in + model + seedString + " " + paraLine + bootstrap;
        RunTreePrograms.runProgram(PhyMLcom, "", outFolder);
    }

    public static void runRAxML(File in, File RAxMLPath, int seqLength, String suffix, String root, boolean noGenes, File parameters, int seed) {
        File outFolder = new File(in.getParent());
        if (!RAxMLPath.exists()) {
            System.err.println("Cannot find raxml executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        String modelFile = "";
        RunTreePrograms.deleteAllRAxMLFiles(outFolder, suffix);
        if (root.length() > 0) {
            root = " -o " + root;
        }
        if (!noGenes) {
            File model = RunTreePrograms.generateModelFile(seqLength, outFolder);
            modelFile = " -q " + model.toString();
        }
        HashMap<String, Boolean> paraHM = RunTreePrograms.getParameters(parameters);
        String paraLine = RunTreePrograms.getParametersLine(parameters);
        String model = paraHM.containsKey("-m") ? "" : " -m GTRGAMMA ";
        String seedString = paraHM.containsKey("-p") ? "" : " -p " + seed + " ";
        root = paraHM.containsKey("-o") ? "" : root;
        String raxMLcom = RAxMLPath + " -s " + in + " -w " + outFolder + model + seedString + " -n " + suffix + " " + root + " " + modelFile + " " + paraLine;
        RunTreePrograms.runProgram(raxMLcom, "", outFolder);
    }

    public static HashMap<String, Boolean> getParameters(File in) {
        HashMap<String, Boolean> para = new HashMap<String, Boolean>();
        try {
            if (in != null && in.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(in));
                String line = br.readLine();
                String[] split = line.split("\\s+");
                int i = 0;
                while (i < split.length) {
                    para.put(split[i], true);
                    ++i;
                }
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return para;
    }

    public static String getParametersLine(File in) {
        String para = "";
        try {
            if (in != null && in.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(in));
                para = line = br.readLine();
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return para;
    }

    public static File runRAxMLGivenTopo(File topo, File in, File RAxMLPath, String suffix, String root, int seed, boolean delete, long time) {
        File outFolder = new File(in.getParent());
        if (!RAxMLPath.exists()) {
            System.err.println("Cannot find raxml executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        File out = new File(outFolder + "/RAxML_result." + suffix);
        if (delete || !out.exists()) {
            String raxMLcom;
            RunTreePrograms.deleteAllRAxMLFiles(outFolder, suffix);
            if (root.length() > 0) {
                root = " -o " + root;
            }
            if (RunTreePrograms.runProgram(raxMLcom = RAxMLPath + " -s " + in + " -w " + outFolder + " -m GTRGAMMA -p " + seed + " -n " + suffix + " " + root + " -f e -t " + topo, "", outFolder, time) != 0) {
                return null;
            }
        }
        return out;
    }

    public static File runRAxMLSiteLikelihood(File tree, File in, File RAxMLPath, String suffix, String root, int seed, boolean delete) {
        File outFolder = new File(in.getParent());
        if (!RAxMLPath.exists()) {
            System.err.println("Cannot find raxml executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        File out = new File(outFolder + "/RAxML_perSiteLLs." + suffix);
        if (delete || !out.exists()) {
            RunTreePrograms.deleteAllRAxMLFiles(outFolder, suffix);
            if (root.length() > 0) {
                root = " -o " + root;
            }
            String raxMLcom = RAxMLPath + " -s " + in + " -w " + outFolder + " -m GTRGAMMA -p " + seed + " -n " + suffix + " -f g -z " + tree;
            RunTreePrograms.runProgram(raxMLcom, "", outFolder);
        }
        return out;
    }

    public static int runProgram(String command, String input, File dir) {
        return RunTreePrograms.runProgram(command, input, dir, null, null, -1L);
    }

    public static int runProgram(String command, File input, File dir) {
        return RunTreePrograms.runProgram(command, "", dir, null, input, -1L);
    }

    public static int runProgram(String command, String input, File dir, long time) {
        return RunTreePrograms.runProgram(command, input, dir, null, null, time);
    }

    public static int runProgram(String command, String input, File dir, File standardOut) {
        return RunTreePrograms.runProgram(command, input, dir, standardOut, null, -1L);
    }

    public static int runProgram(String command, String input, File dir, File standardOut, File standardIn, long time) {
        Timer timer = null;
        Process p = null;
        Boolean[] timeOut = new Boolean[]{false};
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                p = runtime.exec(command, new String[0], dir);
                OutputStream stdin = p.getOutputStream();
                if (standardIn == null) {
                    stdin.write(input.getBytes());
                    stdin.flush();
                    stdin.close();
                } else {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(standardIn));
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(stdin));
                    while ((line = br.readLine()) != null) {
                        bw.write(String.valueOf(line) + "\n");
                    }
                    br.close();
                    bw.close();
                }
                BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = "";
                if (time > -1L) {
                    timer = new Timer(true);
                    InterruptTimerTask interrupter = new InterruptTimerTask(p, timeOut);
                    timer.schedule((TimerTask)interrupter, time);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = br.readLine()) != null) {
                    System.err.println(line);
                }
                if (standardOut == null) {
                    System.out.println(command);
                    while ((line = bri.readLine()) != null) {
                        System.out.println(line);
                    }
                } else {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(standardOut));
                    while ((line = bri.readLine()) != null) {
                        bw.write(String.valueOf(line) + "\n");
                    }
                    bw.close();
                }
                bri.close();
                if (p.waitFor() != 0) {
                    System.err.println(command);
                    while ((line = br.readLine()) != null) {
                        System.err.println(line);
                    }
                    br.close();
                    System.err.println(String.valueOf(command) + " was not successful!");
                    System.exit(-1);
                }
            }
            catch (InterruptedException e) {
                p.destroy();
                e.printStackTrace();
                if (timer != null) {
                    timer.cancel();
                }
                Thread.interrupted();
                return -1;
            }
            catch (IOException e) {
                block23: {
                    if (!timeOut[0].booleanValue()) {
                        e.printStackTrace();
                        System.exit(-1);
                    } else {
                        System.err.println("Program: " + command + " timed out!!!");
                    }
                    if (timer == null) break block23;
                    timer.cancel();
                }
                Thread.interrupted();
                return -1;
            }
        }
        finally {
            if (timer != null) {
                timer.cancel();
            }
            Thread.interrupted();
        }
        return 0;
    }

    public static File runConsense(File in, File consensePath) {
        if (!consensePath.exists()) {
            System.err.println("Cannot find " + consensePath + " executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        String consensecom = consensePath.toString();
        RunTreePrograms.deleteConsenseFiles(in.getParentFile());
        if (!in.getName().equals("intree")) {
            RunTreePrograms.runProgram(consensecom, String.valueOf(in.toString()) + "\ny\r\n", in.getParentFile());
        } else {
            System.err.println("Please do not choose \"intree\" as file name!");
        }
        return new File(in.getParentFile() + "/outfile");
    }

    public static void deleteConsenseFiles(File outFolder) {
        File outfile = new File(outFolder + "/outfile");
        File outtree = new File(outFolder + "/outtree");
        File intree = new File(outFolder + "/intree");
        if (outfile.exists()) {
            outfile.delete();
        }
        if (outtree.exists()) {
            outtree.delete();
        }
        if (intree.exists()) {
            intree.delete();
        }
    }

    public static void runPhyml(File in, String PhymlPath) {
        File phymlExec = new File(PhymlPath);
        if (!phymlExec.exists()) {
            System.err.println("Cannot find Phyml executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        String phymlcom = String.valueOf(PhymlPath) + " -i " + in + " -m F81 -c 1 -f e";
        RunTreePrograms.runProgram(phymlcom, "", in.getParentFile());
    }

    public static void runDNAML(File in, String dnamlPath) {
        File phymlExec = new File(dnamlPath);
        if (!phymlExec.exists()) {
            System.err.println("Cannot find Phyml executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        String phymlcom = dnamlPath;
        RunTreePrograms.runProgram(phymlcom, String.valueOf(in.toString()), in.getParentFile());
    }

    public static void runTreePuzzle(File in, String treePuzzlePath) {
        File puzzleExec = new File(treePuzzlePath);
        if (!puzzleExec.exists()) {
            System.err.println("Cannot find TREE-PUZZLE executable. Not building tree. Exiting.");
            System.exit(-1);
        }
        String treepuzzlecom = String.valueOf(treePuzzlePath) + " " + in;
        RunTreePrograms.runProgram(treepuzzlecom, "w\r\ny\r\n", in.getParentFile());
    }

    private static void deleteAllRAxMLFiles(File folder, String suffix) {
        File[] list = folder.listFiles();
        int i = 0;
        while (i < list.length) {
            if (list[i].getName().endsWith(suffix)) {
                list[i].delete();
            }
            ++i;
        }
    }

    private static File generateModelFile(int seqLength, File outFolder) {
        try {
            File modelOut = new File(outFolder + "/model.txt");
            BufferedWriter bw = new BufferedWriter(new FileWriter(modelOut));
            bw.write("DNA, codon1 = 1-" + seqLength + "\\3\n" + "DNA, codon2 = 2-" + seqLength + "\\3\n" + "DNA, codon3 = 3-" + seqLength + "\\3\n");
            bw.close();
            return modelOut;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

