/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import util.DNAmanipulations;

public class ReadFasta {
    BufferedReader br;
    String previousID = new String();
    String previousLine = new String();
    int bases;
    int w;

    private static HashMap<String, BitSet> readBitSet(BufferedReader br) {
        HashMap<String, BitSet> fasta = new HashMap<String, BitSet>();
        String line = "";
        String id = "";
        try {
            int size = 0;
            int k = 1;
            while ((line = br.readLine()) != null) {
                if (size > k * 1000000) {
                    System.out.println(String.valueOf(k) + "mio bases read...");
                    ++k;
                }
                if (line.startsWith(">")) {
                    id = line;
                    continue;
                }
                if (id.length() == 0) continue;
                line.replaceAll("\\s", "");
                size += line.length();
                if (line.contains("N")) {
                    System.err.println("Ns were converted to Cs!");
                    line = line.toUpperCase().replace('N', 'C');
                }
                if (fasta.containsKey(id)) {
                    fasta.put(id, DNAmanipulations.append(fasta.get(id), DNAmanipulations.codeDNA(line.toUpperCase())));
                    continue;
                }
                fasta.put(id, DNAmanipulations.codeDNA(line.toUpperCase()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fasta;
    }

    public static HashMap<String, BitSet> readFastaBitSet(File f) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            return ReadFasta.readBitSet(br);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return null;
        }
    }

    public static HashMap<String, StringBuilder> readFasta(File f) {
        try {
            BufferedReader sequence = new BufferedReader(new FileReader(f));
            return ReadFasta.read(sequence);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return null;
        }
    }

    private static HashMap<String, StringBuilder> read(BufferedReader br) {
        HashMap<String, StringBuilder> fasta = new HashMap<String, StringBuilder>();
        try {
            String line = "";
            String id = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (!line.startsWith(">gi|")) {
                        id = line.split("\\s+")[0];
                        continue;
                    }
                    id = line.split("\\s+|\\||\\.")[3];
                    continue;
                }
                if (id.length() == 0) continue;
                line.replaceAll("\\s", "");
                if (fasta.containsKey(id)) {
                    fasta.get(id).append(line);
                    continue;
                }
                fasta.put(id, new StringBuilder(line));
            }
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        return fasta;
    }

    public static HashMap<String, StringBuilder> readFasta(String seq) {
        BufferedReader sequence = new BufferedReader(new StringReader(seq));
        return ReadFasta.read(sequence);
    }

    public static ArrayList<Integer> getPositions(String Sequence, String Genome) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        int New = 0;
        int Old = 0;
        Sequence = Sequence.toUpperCase();
        Genome = Genome.toUpperCase();
        while ((New = Genome.indexOf(Sequence, Old)) != -1) {
            al.add(New);
            Old = New + 1;
        }
        return al;
    }

    public static ArrayList<Integer> getPositionsBoth(String Sequence, String Genome) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        int Old = 0;
        Sequence = Sequence.toUpperCase();
        Genome = Genome.toUpperCase();
        String ReverseSequence = DNAmanipulations.reverse(Sequence);
        boolean end = Genome.indexOf(Sequence, Old) == -1 && Genome.indexOf(ReverseSequence, Old) == -1;
        while (!end) {
            int seqfind = Genome.indexOf(Sequence, Old);
            int seqfindRev = Genome.indexOf(ReverseSequence, Old);
            if (seqfind > -1 && seqfindRev > -1) {
                if (seqfind < seqfindRev) {
                    al.add(seqfind + 1);
                    al.add(seqfind + Sequence.length());
                    Old = seqfind + 1;
                    continue;
                }
                al.add(seqfindRev + Sequence.length());
                al.add(seqfindRev + 1);
                Old = seqfindRev + 1;
                continue;
            }
            if (seqfind == -1 && seqfindRev == -1) {
                end = true;
                return al;
            }
            if (seqfind > -1) {
                al.add(seqfind + 1);
                al.add(seqfind + Sequence.length());
                Old = seqfind + 1;
                continue;
            }
            al.add(seqfindRev + Sequence.length());
            al.add(seqfindRev + 1);
            Old = seqfindRev + 1;
        }
        return al;
    }

    public HashMap<String, BitSet> read() {
        int i = 0;
        String id = this.previousID;
        HashMap<String, BitSet> fasta = new HashMap<String, BitSet>();
        boolean start = true;
        try {
            String line;
            while (i < this.bases && (line = this.br.readLine()) != null) {
                if (line.startsWith(">")) {
                    this.previousID = id = line;
                    if (!start) continue;
                    this.previousLine = new String();
                    continue;
                }
                if (id.length() == 0) continue;
                line.replaceAll("\\s", "");
                if (line.toUpperCase().contains("N")) {
                    line = line.toUpperCase().replace('N', 'C');
                    System.err.println("WARNING: Ns replaced by Cs!");
                }
                if (start && this.previousLine.length() > 0) {
                    String p = this.previousLine.substring(this.previousLine.length() - this.w + 1);
                    i += p.length();
                    if (fasta.containsKey(id)) {
                        fasta.put(id, DNAmanipulations.append(fasta.get(id), DNAmanipulations.codeDNA(p.toUpperCase())));
                    } else {
                        fasta.put(id, DNAmanipulations.codeDNA(p.toUpperCase()));
                    }
                }
                start = false;
                i += line.length();
                this.previousLine = line;
                if (fasta.containsKey(id)) {
                    fasta.put(id, DNAmanipulations.append(fasta.get(id), DNAmanipulations.codeDNA(line.toUpperCase())));
                    continue;
                }
                fasta.put(id, DNAmanipulations.codeDNA(line.toUpperCase()));
            }
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        return fasta;
    }

    public ReadFasta(File genome, int basepairs, int wordsize) {
        this.bases = basepairs;
        this.w = wordsize;
        try {
            this.br = new BufferedReader(new FileReader(genome));
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public ReadFasta(String genome, int basepairs, int wordsize) {
        this.bases = basepairs;
        this.w = wordsize;
        this.br = new BufferedReader(new StringReader(genome));
    }

    public static HashMap<String, BitSet> readFastaBitSet(String sequence) {
        BufferedReader br = new BufferedReader(new StringReader(sequence));
        return ReadFasta.readBitSet(br);
    }
}

