/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import util.Interval;

public class Info
extends Interval<Info> {
    private static final long serialVersionUID = 1L;
    public String info;
    public int repNumber = -1;
    char orient;
    int codon_start;
    boolean pseudo;
    String feature;

    public Info(int S, int E, String inf, int RepNumber) {
        super(S, E);
        this.info = inf;
        this.repNumber = RepNumber;
    }

    public Info(int S, int E, String inf) {
        super(S, E);
        this.info = inf;
        this.repNumber = -1;
        this.orient = (char)63;
    }

    public Info(Info inf) {
        super(inf.start, inf.end);
        this.info = inf.info;
        this.orient = inf.orient;
        this.pseudo = inf.pseudo;
        this.codon_start = inf.codon_start;
        this.repNumber = inf.repNumber;
        this.feature = inf.feature;
    }

    public Info setFeature(String Feature2) {
        this.feature = Feature2;
        return this;
    }

    public String getFeature() {
        return this.feature;
    }

    public char getOrient() {
        return this.orient;
    }

    public int getCodonStart() {
        return this.codon_start;
    }

    public Info setCodonStart(int cs) {
        this.codon_start = cs;
        return this;
    }

    public boolean getPseudo() {
        return this.pseudo;
    }

    public Info setPseudo(boolean Pseudo) {
        this.pseudo = Pseudo;
        return this;
    }

    @Override
    public void append(Info s) {
        this.info = String.valueOf(this.info) + " " + s.info;
    }

    public String getInfo() {
        return this.info;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public void setEnd(int e) {
        this.end = e;
    }

    public String toString() {
        return this.start + "\t" + this.end + "\t" + this.info + "\t" + this.orient;
    }

    public String getGeneOrLocusInfo() {
        if (this.info.contains("gene= ")) {
            return this.info.split("gene= ")[1].split("\\s+")[0];
        }
        if (this.info.contains("locus_tag= ")) {
            return this.info.split("locus_tag= ")[1].split("\\s+")[0];
        }
        return "";
    }

    public Info setOrient(char o) {
        this.orient = o;
        return this;
    }

    public static void write(ArrayList<Info> infos, File out) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int i = 0;
            while (i < infos.size()) {
                bw.write(infos.get(i) + "\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

