/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import util.DNAmanipulations;
import util.Fasta;
import util.SequencePositions;

public class BitSetIndexHash {
    HashMap<BitSet, ArrayList<SequencePositions>> index = new HashMap();
    HashMap<Integer, Integer> map;
    int sequence = 0;
    boolean ori;

    public static void main(String[] args) {
        try {
            ArrayList<Fasta> genome = Fasta.readFasta(new File(args[0]));
            ArrayList<Fasta> sequences = Fasta.readFasta(new File(args[1]));
            File out = new File(args[2]);
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            ArrayList<BitSet> Genome = DNAmanipulations.FastaToBitSet(genome);
            int length = DNAmanipulations.codeDNA(sequences.get(0).getSequence()).length();
            BitSetIndexHash bsih = new BitSetIndexHash(Genome, length, true);
            System.out.println("Hash initialised...");
            int i = 0;
            while (i < sequences.size()) {
                System.out.println(sequences.get((int)i).ident);
                BitSet seq = DNAmanipulations.codeDNA(sequences.get(i).getSequence());
                if (length != seq.length()) {
                    System.err.println(String.valueOf(sequences.get((int)i).ident) + " had not the correct length!");
                } else {
                    ArrayList<SequencePositions> al = bsih.getPos(seq);
                    int j = 0;
                    while (j < al.size()) {
                        String orient = al.get((int)j).position > 0 ? "f" : "r";
                        bw.write(String.valueOf(sequences.get((int)i).ident) + "\t" + genome.get((int)al.get((int)j).sequence).ident.replace("\t", "") + "\t" + orient + "\t" + Math.abs(al.get((int)j).position) + "\n");
                        ++j;
                    }
                }
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BitSetIndexHash(ArrayList<BitSet> input, int BitSetLength, boolean orientation) {
        this.ori = orientation;
        int i = 0;
        while (i < input.size()) {
            this.indexing(input.get(i), BitSetLength);
            ++i;
        }
    }

    public BitSetIndexHash(ArrayList<BitSet> input, int BitSetLength, HashMap<Integer, Integer> pos, boolean orientation) {
        this.map = pos;
        this.ori = orientation;
        int i = 0;
        while (i < input.size()) {
            this.indexing(input.get(i), BitSetLength);
            ++i;
        }
    }

    public BitSetIndexHash(BitSet input, int BitSetLength, boolean orientation) {
        this.ori = orientation;
        this.indexing(input, BitSetLength);
    }

    private void indexing(BitSet input, int size) {
        BitSet revInput = input;
        int i = 0;
        while (i < input.length() - size) {
            BitSet key = input.get(i, i + size - 1);
            key.set(size - 1);
            SequencePositions temp = new SequencePositions(this.sequence, i / 2);
            if (this.index.containsKey(key)) {
                this.index.get(key).add(temp);
            } else {
                ArrayList<SequencePositions> al = new ArrayList<SequencePositions>();
                al.add(temp);
                this.index.put(key, al);
            }
            BitSet rev = revInput.get(i, i + size - 1);
            rev.set(size - 1);
            rev = DNAmanipulations.reverse(rev);
            int pos = this.ori ? -i / 2 : i / 2;
            temp = new SequencePositions(this.sequence, pos);
            if (this.index.containsKey(rev)) {
                this.index.get(rev).add(temp);
            } else {
                ArrayList<SequencePositions> al = new ArrayList<SequencePositions>();
                al.add(temp);
                this.index.put(rev, al);
            }
            i += 2;
        }
        ++this.sequence;
    }

    public int getNumber(BitSet key) {
        return this.index.get(key).size();
    }

    public ArrayList<SequencePositions> getPos(BitSet key) {
        if (this.index.containsKey(key)) {
            return this.index.get(key);
        }
        return null;
    }

    public ArrayList<Integer> getPosMap(BitSet key) {
        if (this.index.containsKey(key) && this.map != null) {
            ArrayList<SequencePositions> list = this.index.get(key);
            ArrayList<Integer> pos = new ArrayList<Integer>();
            int i = 0;
            while (i < list.size()) {
                int posi = list.get((int)i).position;
                int position = posi < 0 ? -1 * (this.map.get(list.get((int)i).sequence) + Math.abs(posi)) : this.map.get(list.get((int)i).sequence) + Math.abs(posi);
                pos.add(position);
                ++i;
            }
            return pos;
        }
        return null;
    }

    public int getNumber(ArrayList<BitSet> keys) {
        int sum = 0;
        int i = 0;
        while (i < keys.size()) {
            if (this.index.containsKey(keys.get(i))) {
                sum += this.index.get(keys.get(i)).size();
            }
            ++i;
        }
        return sum;
    }

    public ArrayList<Integer> getPosMap(ArrayList<BitSet> keys) {
        ArrayList<Integer> sum = new ArrayList<Integer>();
        int i = 0;
        while (i < keys.size()) {
            if (this.index.containsKey(keys.get(i))) {
                ArrayList<SequencePositions> list = this.index.get(keys.get(i));
                ArrayList<Integer> pos = new ArrayList<Integer>();
                int j = 0;
                while (j < list.size()) {
                    int posi = list.get((int)j).position;
                    int position = posi < 0 ? -1 * (this.map.get(list.get((int)j).sequence) + Math.abs(posi)) : this.map.get(list.get((int)j).sequence) + posi;
                    pos.add(position);
                    ++j;
                }
                sum.addAll(pos);
            }
            ++i;
        }
        return sum;
    }

    public ArrayList<SequencePositions> getPos(ArrayList<BitSet> keys) {
        ArrayList<SequencePositions> sum = new ArrayList<SequencePositions>();
        int i = 0;
        while (i < keys.size()) {
            if (this.index.containsKey(keys.get(i))) {
                sum.addAll((Collection<SequencePositions>)this.index.get(keys.get(i)));
            }
            ++i;
        }
        return sum;
    }
}

