/*
 * Decompiled with CFR 0.152.
 */
package pairwiseAlignment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import pairwiseAlignment.Alignment;
import util.Fasta;

public class NeedlemanWunsch {
    double dE;
    double dO;
    double[][] A;
    double[][] B;
    double[][] C;
    Alignment al;
    HashMap<Character, HashMap<Character, Integer>> subMatrix = new HashMap();
    String sA;
    String sB;

    public static HashMap<Character, HashMap<Character, Integer>> readSimilarityMatrix(File in) {
        HashMap<Character, HashMap<Character, Integer>> hm = new HashMap<Character, HashMap<Character, Integer>>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(in));
            String line = "";
            boolean first = true;
            String[] order = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] split = line.split("\\s+");
                if (first) {
                    first = false;
                    order = split;
                    continue;
                }
                char c = order[++i].charAt(0);
                hm.put(Character.valueOf(c), new HashMap());
                int j = 1;
                while (j < split.length) {
                    hm.get(Character.valueOf(c)).put(Character.valueOf(order[j].charAt(0)), Integer.parseInt(split[j]));
                    ++j;
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hm;
    }

    public static void main(String[] args) {
        File input = new File(args[0]);
        File in = new File(args[1]);
        ArrayList<Fasta> fas = Fasta.readFasta(input);
        String a = fas.get(0).getSequence().toUpperCase();
        String b = fas.get(1).getSequence().toUpperCase();
        NeedlemanWunsch nw = new NeedlemanWunsch(a, b, NeedlemanWunsch.readSimilarityMatrix(in), 10.0, 0.1);
        System.out.println(nw.getPairwiseIdentity());
        System.out.println(nw.getAlignments());
    }

    public NeedlemanWunsch(String a, String b, HashMap<Character, HashMap<Character, Integer>> matrix, double gapOpen, double gapExtend) {
        a = this.checkForStops(a);
        b = this.checkForStops(b);
        this.sA = a;
        this.sB = b;
        this.subMatrix = matrix;
        this.dE = gapExtend;
        this.dO = gapOpen;
        this.calculateMatrix();
        this.doAlignments();
    }

    public String checkForStops(String a) {
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < a.length()) {
            if (a.charAt(i) != '#' && a.charAt(i) != '*' && a.charAt(i) != '+') {
                temp.append(a.charAt(i));
            }
            ++i;
        }
        return temp.toString();
    }

    public Alignment getAlignments() {
        return this.al;
    }

    public double getScore() {
        return this.max(this.A[this.A.length - 1][this.A[this.A.length - 1].length - 1], this.B[this.B.length - 1][this.B[this.B.length - 1].length - 1], this.C[this.C.length - 1][this.C[this.C.length - 1].length - 1]);
    }

    public static double getPairwiseIdentity(String a, String b) {
        if (a.length() != b.length()) {
            System.err.println("String a has not the same length as string b. Return NaN.");
            return Double.NaN;
        }
        int identities = 0;
        int i = 0;
        while (i < a.length()) {
            if (a.charAt(i) == b.charAt(i)) {
                ++identities;
            }
            ++i;
        }
        return 1.0 * (double)identities / (double)((a.length() + b.length()) / 2);
    }

    public static double getPairwiseDifferences(String a, String b) {
        if (a.length() != b.length()) {
            System.err.println("String a has not the same length as string b. Return NaN.");
            return Double.NaN;
        }
        int differences = 0;
        int i = 0;
        while (i < a.length()) {
            if (a.charAt(i) != b.charAt(i)) {
                ++differences;
            }
            ++i;
        }
        return 1.0 * (double)differences / (double)((a.length() + b.length()) / 2);
    }

    public double getPairwiseIdentity() {
        int identities = 0;
        int i = 0;
        while (i < this.al.alA.length()) {
            if (this.al.alA.charAt(i) == this.al.alB.charAt(i)) {
                ++identities;
            }
            ++i;
        }
        return 1.0 * (double)identities / (double)((this.al.alA.length() + this.al.alB.length()) / 2);
    }

    public void doAlignments() {
        double score;
        int j;
        this.sA = this.sA.toUpperCase();
        this.sB = this.sB.toUpperCase();
        String alA = "";
        String alB = "";
        int i = this.sA.length();
        int mat = this.A[i][j = this.sB.length()] == (score = this.max(this.A[i][j], this.B[i][j], this.C[i][j])) ? 97 : (this.B[i][j] == score ? 98 : 99);
        while (i > 0 && j > 0) {
            double scoreleft = this.B[i - 1][j];
            double scoreup = this.C[i][j - 1];
            if (mat == 97) {
                score = this.max(this.A[i - 1][j - 1], this.B[i - 1][j - 1], this.C[i - 1][j - 1]);
                mat = this.A[i - 1][j - 1] == score ? 97 : (this.B[i - 1][j - 1] == score ? 98 : 99);
                alA = String.valueOf(this.sA.charAt(i - 1)) + alA;
                alB = String.valueOf(this.sB.charAt(j - 1)) + alB;
                --i;
                --j;
                continue;
            }
            if (mat == 98) {
                score = this.max(this.A[i - 1][j] - this.dO, this.B[i - 1][j] - this.dE, this.C[i - 1][j] - this.dO);
                mat = this.A[i - 1][j] - this.dO == score ? 97 : (this.B[i - 1][j] - this.dE == score ? 98 : 99);
                alA = String.valueOf(this.sA.charAt(i - 1)) + alA;
                alB = "-" + alB;
                --i;
                continue;
            }
            if (mat == 99) {
                score = this.max(this.A[i][j - 1] - this.dO, this.B[i][j - 1] - this.dO, this.C[i][j - 1] - this.dE);
                mat = this.A[i][j - 1] - this.dO == score ? 97 : (this.B[i][j - 1] - this.dO == score ? 98 : 99);
                alA = "-" + alA;
                alB = String.valueOf(this.sB.charAt(j - 1)) + alB;
                --j;
                continue;
            }
            System.err.println("Error: " + score + " " + scoreup + " " + scoreleft + " ");
            break;
        }
        while (i > 0) {
            alA = String.valueOf(this.sA.charAt(i - 1)) + alA;
            alB = "-" + alB;
            --i;
        }
        while (j > 0) {
            alA = "-" + alA;
            alB = String.valueOf(this.sB.charAt(j - 1)) + alB;
            --j;
        }
        this.al = new Alignment(alA, alB);
    }

    public void calculateMatrix() {
        String source = this.sA.toUpperCase();
        String dest = this.sB.toUpperCase();
        this.A = new double[source.length() + 1][dest.length() + 1];
        this.B = new double[source.length() + 1][dest.length() + 1];
        this.C = new double[source.length() + 1][dest.length() + 1];
        int y = 0;
        while (y < source.length()) {
            this.A[y][0] = 0.0;
            this.B[y][0] = 0.0;
            this.C[y][0] = 0.0;
            ++y;
        }
        int x = 0;
        while (x < dest.length()) {
            this.A[0][x] = 0.0;
            this.B[0][x] = 0.0;
            this.C[0][x] = 0.0;
            ++x;
        }
        y = 1;
        while (y < source.length() + 1) {
            int x2 = 1;
            while (x2 < dest.length() + 1) {
                double k = this.A[y - 1][x2 - 1] + (double)this.similar(source.charAt(y - 1), dest.charAt(x2 - 1));
                double l = this.B[y - 1][x2 - 1] + (double)this.similar(source.charAt(y - 1), dest.charAt(x2 - 1));
                double m = this.C[y - 1][x2 - 1] + (double)this.similar(source.charAt(y - 1), dest.charAt(x2 - 1));
                this.A[y][x2] = this.max(k, l, m);
                k = this.A[y - 1][x2] - this.dO;
                l = this.B[y - 1][x2] - this.dE;
                m = this.C[y - 1][x2] - this.dO;
                this.B[y][x2] = this.max(k, l, m);
                k = this.A[y][x2 - 1] - this.dO;
                l = this.B[y][x2 - 1] - this.dO;
                m = this.C[y][x2 - 1] - this.dE;
                this.C[y][x2] = this.max(k, l, m);
                ++x2;
            }
            ++y;
        }
    }

    double max(double ... paras) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < paras.length) {
            if (paras[i] > max) {
                max = paras[i];
            }
            ++i;
        }
        return max;
    }

    public int similar(char first, char second) {
        return this.subMatrix.get(Character.valueOf(first)).get(Character.valueOf(second));
    }
}

