/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import buildTreesFromSequenceData.RealPhy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import util.Fasta;
import util.Info;
import util.ReadGenbank;
import util.phylogenetics.Alignment;

public class TestResult {
    Alignment algTrue;
    Alignment algRP;
    ArrayList<Integer> cov = new ArrayList();
    ArrayList<Integer> alignmentPos = new ArrayList();
    HashMap<String, Integer> transRP;
    HashMap<String, HashMap<Integer, Character>> details = new HashMap();
    int referencePos;
    File outFolder;

    public static void main(String[] args) {
        File alignment = new File(args[0]);
        File detailsFolder = new File(args[1]);
        String ref = args[2];
        File out = new File(args[3]);
        boolean genes = Boolean.parseBoolean(args[4]);
        if (genes) {
            ArrayList<ArrayList<Fasta>> seqs = TestResult.getSequences(alignment.getParentFile());
            alignment = TestResult.makeTrueAlignment(alignment, seqs);
        }
        TestResult tr = new TestResult(detailsFolder, alignment, ref, out);
    }

    private static ArrayList<ArrayList<Fasta>> getSequences(File seqfolder) {
        File[] list = seqfolder.listFiles();
        ArrayList<ArrayList<Fasta>> seqs = new ArrayList<ArrayList<Fasta>>();
        int i = 0;
        while (i < list.length) {
            String name = list[i].getName();
            if (RealPhy.hasExtension(name, RealPhy.gbkExt)) {
                ReadGenbank rgb = new ReadGenbank(list[i], new String[0]);
                ArrayList<Fasta> fas = rgb.getSequence();
                seqs.add(fas);
            } else if (RealPhy.hasExtension(name, RealPhy.fasExt)) {
                ArrayList<Fasta> fas = Fasta.readFasta(list[i]);
                seqs.add(fas);
            }
            ++i;
        }
        return seqs;
    }

    private static File makeTrueAlignment(File gbk, ArrayList<ArrayList<Fasta>> seqs) {
        ReadGenbank rgb = new ReadGenbank(gbk, "CDS");
        ArrayList<Info> regions = rgb.getFirstSequenceFeatures();
        ArrayList<Fasta> trueAl = new ArrayList<Fasta>();
        File out = new File(String.valueOf(gbk.getParent()) + "/trueAlignment.fas_temp");
        int i = 0;
        while (i < seqs.size()) {
            String id = seqs.get(i).get(0).getIdent();
            StringBuffer temp = new StringBuffer();
            String seq = seqs.get(i).get(0).getSequence();
            int j = 0;
            while (j < regions.size()) {
                int start = regions.get(j).getStart();
                int end = regions.get(j).getEnd();
                temp.append(seq.substring(start, end));
                ++j;
            }
            trueAl.add(new Fasta(id, temp.toString()));
            ++i;
        }
        Fasta.write(trueAl, out);
        return out;
    }

    public TestResult(File detailsFolder, File alignment, String ref, File outFolder) {
        this.algTrue = new Alignment(Fasta.readFasta(alignment));
        this.algRP = new Alignment(Fasta.readFasta(new File(detailsFolder + "/polymorphisms_move.fas")));
        this.referencePos = this.getReference(ref);
        this.transRP = this.trans(this.algRP.getIdents());
        this.outFolder = outFolder;
        File coverageFile = new File(detailsFolder + "/coverage.txt");
        this.readCoverage(coverageFile);
        this.readDetails(detailsFolder);
        this.testRealPhy();
        this.makeAlignment();
        this.compareAlignments();
    }

    private void makeAlignment() {
        File out = new File(this.outFolder + "/newAlignment.fas");
        Alignment alg = new Alignment();
        int j = 0;
        int i = 0;
        while (i < this.cov.size()) {
            if (this.cov.get(i) == 1) {
                alg.addColumn(this.algRP.getColumn(j));
                ++j;
            } else {
                alg.addColumn("---");
            }
            ++i;
        }
        Fasta.write(alg.toFasta(), out);
    }

    public void printIdents(Alignment alg) {
        ArrayList<String> idents = alg.getIdents();
        int i = 0;
        while (i < idents.size()) {
            System.out.println(idents.get(i));
            ++i;
        }
    }

    public void compareAlignments() {
        int sum = 0;
        int i = 0;
        while (i < this.alignmentPos.size()) {
            if (!this.equals(i, this.alignmentPos.get(i))) {
                ++sum;
                System.out.println("Alignment column " + i + " in RP alignment does not equal true alignment at pos " + this.alignmentPos.get(i) + ".");
            }
            ++i;
        }
        System.out.println(sum);
    }

    public void readDetails(File detailsFolder) {
        ArrayList<String> idents = this.algTrue.getIdents();
        int i = 0;
        while (i < idents.size()) {
            File d = new File(detailsFolder + "/" + idents.get(i) + "details.txt");
            this.details.put(idents.get(i), this.readDetail(d));
            ++i;
        }
    }

    public HashMap<Integer, Character> readDetail(File detail) {
        HashMap<Integer, Character> hm = new HashMap<Integer, Character>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(detail));
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (++i == 1) continue;
                String[] split = line.split("\\s+");
                int truePos = Integer.parseInt(split[5]) - 1;
                hm.put(truePos, Character.valueOf(split[7].toUpperCase().charAt(0)));
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return hm;
    }

    private int getReference(String ref) {
        ArrayList<String> idents = this.algTrue.getIdents();
        int i = 0;
        while (i < idents.size()) {
            if (ref.equals(idents.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void testRealPhy() {
        if (this.referencePos == -1) {
            System.err.println("Reference not found in alignment.");
            System.exit(-1);
        }
        int sum = 0;
        int i = 0;
        while (i < this.cov.size()) {
            if (this.cov.get(i) == 1) {
                boolean invarDet;
                ++sum;
                boolean invarAlg = this.isInvariantAlg(i);
                if (invarAlg != (invarDet = this.isInvariantDetails(i))) {
                    System.err.println("Problem with alignment position " + i + ". Alignment site is " + (invarAlg ? "invariant" : "variable") + " and site in details file is " + (invarDet ? "invariant." : "variable."));
                } else if (!invarAlg && !this.isEqualVariable(i)) {
                    System.err.println("Called polymorphisms differ between correct alignment and details file at position: " + i);
                }
            }
            ++i;
        }
        System.out.println(sum);
    }

    private boolean isEqualVariable(int pos) {
        ArrayList<String> idents = this.algTrue.getIdents();
        String site = this.algTrue.getColumn(pos).toUpperCase();
        char refC = site.charAt(this.referencePos);
        int i = 0;
        while (i < idents.size()) {
            if (i != this.referencePos) {
                char cAlg = site.charAt(i);
                char cDet = this.details.get(idents.get(i)).containsKey(pos) ? this.details.get(idents.get(i)).get(pos).charValue() : refC;
                if (cDet != cAlg) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private HashMap<String, Integer> trans(ArrayList<String> id) {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        int i = 0;
        while (i < id.size()) {
            hm.put(id.get(i), i);
            ++i;
        }
        return hm;
    }

    private boolean equals(int posRP, int posTrue) {
        ArrayList<String> idents = this.algTrue.getIdents();
        String siteTrue = this.algTrue.getColumn(posTrue).toUpperCase();
        String siteRP = this.algRP.getColumn(posRP).toUpperCase();
        int i = 0;
        while (i < idents.size()) {
            char cTrue = siteTrue.charAt(i);
            char cRP = siteRP.charAt(this.transRP.get(idents.get(i)));
            if (cRP != cTrue) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isInvariantDetails(int pos) {
        ArrayList<String> idents = this.algTrue.getIdents();
        int i = 0;
        while (i < idents.size()) {
            if (this.details.get(idents.get(i)).containsKey(pos)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isInvariantAlg(int pos) {
        String site = this.algTrue.getColumn(pos);
        char c = site.charAt(0);
        int i = 1;
        while (i < site.length()) {
            if (c != site.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void readCoverage(File coverage) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(coverage));
            int i = 0;
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\\s+");
                int covered = Integer.parseInt(split[1]);
                this.cov.add(covered);
                if (covered == 1) {
                    this.alignmentPos.add(i);
                }
                ++i;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

