/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import buildTreesFromSequenceData.RealPhy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import util.Fasta;
import util.ReadGenbank;

public class CutUpSequences {
    public static void main(String[] args) {
        CutUpSequences.runCutUpSequences(args);
    }

    public static ArrayList<File> runCutUpSequences(String[] args) {
        ArrayList<File> cutSeqs = new ArrayList<File>();
        File inputFolder = new File(args[0]);
        int length = Integer.parseInt(args[1]);
        File outputFolder = new File(args[2]);
        boolean clean = new Boolean(args[3]);
        File[] files = inputFolder.listFiles();
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (RealPhy.hasExtension(name, RealPhy.fasExt) || RealPhy.hasExtension(name, RealPhy.gbkExt)) {
                File temp = CutUpSequences.cutFasta(files[i], length, outputFolder, clean);
                if (temp != null && !hm.containsKey(temp.getName())) {
                    hm.put(temp.getName(), true);
                    cutSeqs.add(temp);
                }
            } else if (RealPhy.hasExtension(name, RealPhy.fastqExt)) {
                cutSeqs.add(files[i]);
            } else if (RealPhy.hasExtension(name, RealPhy.gzExt)) {
                cutSeqs.add(files[i]);
            }
            ++i;
        }
        return cutSeqs;
    }

    public static File cutFastaSimple(File fas, int length, File cutFolder, boolean clean) {
        try {
            int j;
            StringBuffer sb;
            File out;
            String name = fas.getName();
            String id = RealPhy.getId(name);
            if (!cutFolder.exists()) {
                cutFolder.mkdir();
            }
            if ((out = new File(cutFolder + "/" + id + "_" + length + ".fastq")).exists() && !clean) {
                System.out.println(out + " already exists. Continue with next file.");
                return out;
            }
            BufferedReader br = new BufferedReader(new FileReader(fas));
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            String line = "";
            String[] lines = new String[4];
            int k = 0;
            Fasta fasta = new Fasta("", "");
            int warning = 0;
            while ((line = br.readLine()) != null) {
                if (k > 0 && line.startsWith(">")) {
                    lines[0] = "@" + fasta.getIdent();
                    lines[1] = fasta.getSequence();
                    lines[2] = "+";
                    sb = new StringBuffer();
                    j = 0;
                    while (j < lines[1].length()) {
                        sb.append('J');
                        ++j;
                    }
                    lines[3] = sb.toString();
                    if (lines[1].length() < length && ++warning == 1) {
                        System.err.println("In file " + fas.getName() + " at least one of the fasta sequences is shorter (" + lines[1].length() + ") than the specified readLength(" + length + ")!");
                    }
                    CutUpSequences.write(lines, length, bw);
                    fasta = new Fasta(line.trim().substring(1), "");
                } else if (!line.startsWith(">")) {
                    line = line.replaceAll("\\s+", "");
                    fasta.setSequence(String.valueOf(fasta.getSequence()) + line);
                } else if (k == 0 && line.startsWith(">")) {
                    fasta.setIdent(line.trim().substring(1));
                }
                k = 1;
            }
            lines[0] = "@" + fasta.getIdent();
            lines[1] = fasta.getSequence();
            lines[2] = "+";
            sb = new StringBuffer();
            j = 0;
            while (j < lines[1].length()) {
                sb.append('J');
                ++j;
            }
            lines[3] = sb.toString();
            CutUpSequences.write(lines, length, bw);
            bw.close();
            br.close();
            return out;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static File cutFastq(File fastq, int length, File cutFolder, boolean clean) {
        try {
            File out;
            String name = fastq.getName();
            String id = RealPhy.getId(name);
            if (!cutFolder.exists()) {
                cutFolder.mkdir();
            }
            if ((out = new File(cutFolder + "/" + id + "_" + length + "fastq.fastq.gz")).exists() && !clean) {
                System.out.println(out + " already exists. Continue with next file.");
                return out;
            }
            FileOutputStream fos = new FileOutputStream(out);
            GZIPOutputStream gzipOS = new GZIPOutputStream(fos);
            OutputStreamWriter osw = new OutputStreamWriter(gzipOS);
            BufferedWriter bw = new BufferedWriter(osw);
            BufferedReader br = new BufferedReader(new FileReader(fastq));
            String line = "";
            int j = 0;
            String[] lines = new String[4];
            int warning = 0;
            boolean write = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (j % 4 == 0 && j > 0) {
                    if (lines[1].length() < length && ++warning == 1) {
                        System.err.println("In file " + fastq.getName() + " at least one of the fastq sequences is shorter (" + lines[1].length() + ") than the specified readLength(" + length + ")!");
                    }
                    if (lines[1].length() > 30) {
                        CutUpSequences.write(lines, length, bw);
                        write = true;
                    }
                }
                lines[j % 4] = line;
                ++j;
            }
            CutUpSequences.write(lines, length, bw);
            br.close();
            bw.close();
            if (write) {
                return out;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static void write(String[] lines, int splitLength, BufferedWriter bw) throws IOException {
        String id = lines[0];
        String seq = lines[1];
        String quality = lines[3];
        if (seq.length() < splitLength) {
            bw.write(String.valueOf(id) + "_0\n" + seq + "\n" + lines[2] + "\n" + quality + "\n");
        } else {
            int i = 0;
            while (i < seq.length() / splitLength) {
                bw.write(String.valueOf(id) + "_" + i + "\n" + seq.substring(i * splitLength, (i + 1) * splitLength) + "\n" + lines[2] + "\n" + quality.substring(i * splitLength, (i + 1) * splitLength) + "\n");
                ++i;
            }
        }
    }

    public static File cutFasta(File fasta, int length, File cutFolder, boolean clean) {
        File out;
        block8: {
            try {
                String name = fasta.getName();
                String id = RealPhy.getId(name);
                if (!cutFolder.exists()) {
                    cutFolder.mkdir();
                }
                if ((out = new File(cutFolder + "/" + id + "_" + length + "fasta.fastq.gz")).exists() && !clean) {
                    System.out.println(out + " already exists. Continue with next file.");
                    return out;
                }
                ArrayList<Fasta> fas = RealPhy.hasExtension(name, RealPhy.fasExt) ? Fasta.readFasta(fasta) : new ReadGenbank(fasta, new String[0]).getSequence();
                FileOutputStream fos = new FileOutputStream(out);
                GZIPOutputStream gzipOS = new GZIPOutputStream(fos);
                OutputStreamWriter osw = new OutputStreamWriter(gzipOS);
                BufferedWriter bw = new BufferedWriter(osw);
                boolean write = false;
                int size = fas.size();
                int total = 0;
                int j = 0;
                while (j < size) {
                    String seq = fas.get(j).getSequence();
                    int seqLength = seq.length();
                    int k = 0;
                    while (k <= seqLength - length) {
                        write = true;
                        bw.write("@" + total + "\n");
                        bw.write(String.valueOf(seq.substring(k, k + length)) + "\n");
                        bw.write("+\n");
                        ++total;
                        int m = 0;
                        while (m < length) {
                            bw.write("J");
                            ++m;
                        }
                        bw.write("\n");
                        ++k;
                    }
                    ++j;
                }
                bw.close();
                if (write) break block8;
                out.delete();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
                return null;
            }
        }
        return out;
    }
}

