/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import util.ReadFasta;

public class GCcontent {
    public static void main(String[] args) {
        File fasta = new File(args[0]);
        HashMap<String, StringBuilder> fas = ReadFasta.readFasta(fasta);
        Iterator<Map.Entry<String, StringBuilder>> it = fas.entrySet().iterator();
        HashMap<Character, Integer> overall = new HashMap<Character, Integer>();
        while (it.hasNext()) {
            Map.Entry<String, StringBuilder> e = it.next();
            HashMap<Character, Integer> current = GCcontent.countATGC(e.getValue().toString());
            GCcontent.output(current);
            System.out.println("Sequencelength: " + e.getValue().length());
            overall = GCcontent.add(overall, current);
        }
        System.out.println("Overall:");
        GCcontent.output(overall);
    }

    public static HashMap<Character, Integer> countATGC(String sequence) {
        HashMap<Character, Integer> atgc = new HashMap<Character, Integer>();
        atgc.put(Character.valueOf('A'), 0);
        atgc.put(Character.valueOf('T'), 0);
        atgc.put(Character.valueOf('G'), 0);
        atgc.put(Character.valueOf('C'), 0);
        int i = 0;
        while (i < sequence.length() / 2) {
            Character c = Character.valueOf(Character.toUpperCase(sequence.charAt(i)));
            if (atgc.containsKey(c)) {
                atgc.put(c, atgc.get(c) + 1);
            }
            ++i;
        }
        return atgc;
    }

    public static HashMap<Character, Integer> add(HashMap<Character, Integer> h1, HashMap<Character, Integer> h2) {
        for (Map.Entry<Character, Integer> e : h1.entrySet()) {
            if (h2.containsKey(e.getKey())) {
                h2.put(e.getKey(), e.getValue() + h2.get(e.getKey()));
                continue;
            }
            h2.put(e.getKey(), e.getValue());
        }
        return h2;
    }

    public static void output(HashMap<Character, Integer> h) {
        double gcCont = 0.0;
        gcCont = ((double)(h.get(Character.valueOf('G')) + h.get(Character.valueOf('C'))) + 0.0) / ((double)(h.get(Character.valueOf('C')) + h.get(Character.valueOf('G')) + h.get(Character.valueOf('A')) + h.get(Character.valueOf('T'))) + 0.0) * 100.0;
        System.out.println("G: " + h.get(Character.valueOf('G')) + "\nC: " + h.get(Character.valueOf('C')) + "\nA: " + h.get(Character.valueOf('A')) + "\nT: " + h.get(Character.valueOf('T')) + "\nGC content:" + gcCont + "%");
    }
}

