/*
 * Decompiled with CFR 0.152.
 */
package solexa;

import java.io.Serializable;
import java.util.HashMap;

public class Arrays
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[][] array;
    double[] cov;
    HashMap<Integer, Integer>[] queryID;
    public final int length;
    String ref;
    public static String[] bases = new String[]{"AF", "TF", "CF", "GF", "-F", "AR", "TR", "CR", "GR", "-R"};
    static HashMap<Character, Character> complement = new HashMap();

    static {
        complement.put(Character.valueOf('A'), Character.valueOf('T'));
        complement.put(Character.valueOf('T'), Character.valueOf('A'));
        complement.put(Character.valueOf('C'), Character.valueOf('G'));
        complement.put(Character.valueOf('G'), Character.valueOf('C'));
    }

    public Arrays(int Length) {
        this.length = Length;
        this.array = new double[this.length][10];
        this.queryID = new HashMap[this.length];
    }

    public Arrays(String ref) {
        this.length = ref.length() + 1;
        this.ref = ref;
        this.array = new double[this.length][10];
        this.queryID = new HashMap[this.length];
    }

    public void setCoverage(double[] Coverage) {
        this.cov = Coverage;
    }

    public double[] getCoverage() {
        return this.cov;
    }

    public void set(int pos, String base, double weight) {
        if (base.charAt(1) == 'F') {
            if (base.charAt(0) == 'A' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[0] = dArray[0] + weight;
                return;
            }
            if (base.charAt(0) == 'T' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[1] = dArray[1] + weight;
                return;
            }
            if (base.charAt(0) == 'C' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[2] = dArray[2] + weight;
                return;
            }
            if (base.charAt(0) == 'G' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[3] = dArray[3] + weight;
                return;
            }
            if (base.charAt(0) == '-' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[4] = dArray[4] + weight;
                return;
            }
        } else if (base.charAt(1) == 'R') {
            if (base.charAt(0) == 'A' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[5] = dArray[5] + weight;
                return;
            }
            if (base.charAt(0) == 'T' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[6] = dArray[6] + weight;
                return;
            }
            if (base.charAt(0) == 'C' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[7] = dArray[7] + weight;
                return;
            }
            if (base.charAt(0) == 'G' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[8] = dArray[8] + weight;
                return;
            }
            if (base.charAt(0) == '-' && pos < this.array.length) {
                double[] dArray = this.array[pos];
                dArray[9] = dArray[9] + weight;
                return;
            }
        }
    }

    public void set(int pos, String base, double weight, String readSequence) {
        char refb;
        base = base.toUpperCase();
        if (this.ref != null && complement.containsKey(Character.valueOf(refb = this.ref.charAt(pos - 1)))) {
            char refc = complement.get(Character.valueOf(refb)).charValue();
            if ((String.valueOf(refb) + "F").equals(base) || (String.valueOf(refc) + "R").equals(base)) {
                throw new RuntimeException("Substitutions that are identical with the reference are not possible!\n" + readSequence + "\n" + pos + "\n" + base + "\n" + this.ref);
            }
        }
        this.set(pos, base, weight);
    }

    public void addPseudoCount(double count, String ref) {
        int i = 1;
        while (i < this.array.length) {
            int n = i;
            this.cov[n] = this.cov[n] + count * 8.0;
            char r = ref.charAt(i - 1);
            char c = complement.get(Character.valueOf(r)).charValue();
            int j = 0;
            while (j < this.array[i].length) {
                if (bases[j].charAt(1) == 'F' && r != bases[j].charAt(0) || bases[j].charAt(1) == 'R' && c != bases[j].charAt(0)) {
                    double[] dArray = this.array[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + count;
                }
                ++j;
            }
            ++i;
        }
    }

    public void set(int pos, String base, int readPos, double weight, String readSeq) {
        this.set(pos, base, weight, readSeq);
        if (this.queryID[pos] == null) {
            HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
            temp.put(readPos, 1);
            this.queryID[pos] = temp;
        } else if (this.queryID[pos].containsKey(readPos)) {
            int item = this.queryID[pos].get(readPos);
            this.queryID[pos].put(readPos, ++item);
        }
    }

    public boolean isset(int pos) {
        return this.queryID[pos] != null;
    }

    public double numBases(int pos) {
        double sum = 0.0;
        int i = 0;
        while (i < this.array[pos].length) {
            sum += this.array[pos][i];
            ++i;
        }
        return sum;
    }

    public double numBasesNoGaps(int pos) {
        double sum = 0.0;
        int i = 0;
        while (i < this.array[pos].length) {
            sum += i != 9 && i != 4 ? this.array[pos][i] : 0.0;
            ++i;
        }
        return sum;
    }

    public double get(int pos, String base) {
        if ((base = base.toUpperCase()).charAt(1) == 'F') {
            if (base.charAt(0) == 'A' && pos < this.array.length) {
                return this.array[pos][0];
            }
            if (base.charAt(0) == 'T' && pos < this.array.length) {
                return this.array[pos][1];
            }
            if (base.charAt(0) == 'C' && pos < this.array.length) {
                return this.array[pos][2];
            }
            if (base.charAt(0) == 'G' && pos < this.array.length) {
                return this.array[pos][3];
            }
            if (base.charAt(0) == '-' && pos < this.array.length) {
                return this.array[pos][4];
            }
        } else if (base.charAt(1) == 'R') {
            if (base.charAt(0) == 'A' && pos < this.array.length) {
                return this.array[pos][5];
            }
            if (base.charAt(0) == 'T' && pos < this.array.length) {
                return this.array[pos][6];
            }
            if (base.charAt(0) == 'C' && pos < this.array.length) {
                return this.array[pos][7];
            }
            if (base.charAt(0) == 'G' && pos < this.array.length) {
                return this.array[pos][8];
            }
            if (base.charAt(0) == '-' && pos < this.array.length) {
                return this.array[pos][9];
            }
        }
        return -1.0;
    }

    public double getFrequency(int pos) {
        return this.numBases(pos) * 1.0 / (this.cov[pos] * 1.0);
    }

    public double getFrequencyNoGaps(int pos) {
        return this.numBasesNoGaps(pos) * 1.0 / (this.cov[pos] * 1.0);
    }

    public HashMap<Integer, Integer> getQueryID(int pos) {
        return this.queryID[pos];
    }

    public int getMaxNuc(int pos) {
        double max = -1.0;
        int nuc = -1;
        int i = 0;
        while (i < this.array[pos].length) {
            nuc = max > this.array[pos][i] ? nuc : i;
            max = max > this.array[pos][i] ? max : this.array[pos][i];
            ++i;
        }
        return nuc;
    }

    public char getMaxNucForward(int pos) {
        int nuc = this.getMaxNuc(pos);
        return (char)(nuc == 0 || nuc == 6 ? 65 : (nuc == 1 || nuc == 5 ? 84 : (nuc == 2 || nuc == 8 ? 67 : (nuc == 3 || nuc == 7 ? 71 : 45))));
    }

    public double numPolymorphism(int pos, char base) {
        char nuc = base;
        if (nuc == 'A') {
            return this.array[pos][0] + this.array[pos][6];
        }
        if (nuc == 'T') {
            return this.array[pos][1] + this.array[pos][5];
        }
        if (nuc == 'C') {
            return this.array[pos][2] + this.array[pos][8];
        }
        if (nuc == 'G') {
            return this.array[pos][3] + this.array[pos][7];
        }
        return this.array[pos][4] + this.array[pos][9];
    }

    public double numMajorPolymorphism(int pos) {
        char nuc = this.getMaxNucForward(pos);
        if (nuc == 'A') {
            return this.array[pos][0] + this.array[pos][6];
        }
        if (nuc == 'T') {
            return this.array[pos][1] + this.array[pos][5];
        }
        if (nuc == 'C') {
            return this.array[pos][2] + this.array[pos][8];
        }
        if (nuc == 'G') {
            return this.array[pos][3] + this.array[pos][7];
        }
        return this.array[pos][4] + this.array[pos][9];
    }
}

