/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class QueryID
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap<Integer, HashMap<Integer, Integer>> qID = new HashMap();
    ArrayList<Query> qIDList = new ArrayList();
    ArrayList<String> contigsList = new ArrayList();
    HashMap<String, Integer> contigs = new HashMap();
    HashMap<Integer, Boolean> removed = new HashMap();

    public void remove(int key) {
        this.removed.put(key, true);
    }

    public int get(String query) {
        Query q = this.parse(query);
        int pos = q.pos;
        int contig = q.contig;
        if (this.qID.containsKey(contig)) {
            if (this.qID.get(contig).containsKey(pos)) {
                int id = this.qID.get(contig).get(pos);
                if (!this.removed.containsKey(id)) {
                    return id;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public String get(int query) {
        if (query < this.qIDList.size() && query >= 0 && !this.removed.containsKey(query)) {
            Query q = this.qIDList.get(query);
            return String.valueOf(this.contigsList.get(q.contig)) + "_" + q.pos;
        }
        return null;
    }

    public ArrayList<Integer> add(ArrayList<String> queries) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        int i = 0;
        while (i < queries.size()) {
            keys.add(this.add(queries.get(i)));
            ++i;
        }
        return keys;
    }

    public ArrayList<Integer> get(ArrayList<String> queries) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        int i = 0;
        while (i < queries.size()) {
            int key = this.get(queries.get(i));
            if (key > -1) {
                keys.add(key);
            }
            ++i;
        }
        return keys;
    }

    public int add(String query) {
        Query q = this.parse(query);
        int pos = q.pos;
        int contig = q.contig;
        if (this.qID.containsKey(contig)) {
            if (this.qID.get(contig).containsKey(pos)) {
                int id = this.qID.get(contig).get(pos);
                if (this.removed.containsKey(id)) {
                    this.removed.remove(id);
                }
                return id;
            }
            int id = this.qIDList.size();
            this.qID.get(contig).put(pos, id);
            this.qIDList.add(q);
            return id;
        }
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        int id = this.qIDList.size();
        hm.put(pos, id);
        this.qID.put(contig, hm);
        this.qIDList.add(q);
        return id;
    }

    private int addContigs(String contig) {
        if (!this.contigs.containsKey(contig)) {
            int id = this.contigsList.size();
            this.contigs.put(contig, id);
            this.contigsList.add(contig);
            return id;
        }
        return this.contigs.get(contig);
    }

    public Query parse(String q) {
        String[] split = q.split("_");
        String posS = split[split.length - 1];
        int pos = Integer.parseInt(posS);
        String contigS = q.substring(0, q.length() - posS.length() - 1);
        int contig = this.addContigs(contigS);
        return new Query(contig, pos);
    }

    class Query
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int contig;
        int pos;

        public Query(int contig, int pos) {
            this.contig = contig;
            this.pos = pos;
        }
    }
}

