/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import statistics.Stats;

public class DrawGeneNumberCurve {
    public static void main(String[] args) {
        File groupsFile = new File(args[0]);
        int draws = Integer.parseInt(args[1]);
        String id = groupsFile.getName().split("\\.")[0];
        File absoluteGeneNumbers = new File(String.valueOf(groupsFile.getParent()) + "/" + id + "_geneNumbers_" + draws + ".plot");
        File numberOfGroups = new File(String.valueOf(groupsFile.getParent()) + "/" + id + "_groupNumbers_" + draws + ".plot");
        ArrayList<String> strains = new ArrayList<String>();
        HashMap<String, Integer> geneNumbers = new HashMap<String, Integer>();
        HashMap<String, HashMap<Integer, Boolean>> groupNumbers = new HashMap<String, HashMap<Integer, Boolean>>();
        DrawGeneNumberCurve.getGeneNumbers(groupsFile, strains, geneNumbers);
        strains = new ArrayList();
        DrawGeneNumberCurve.getGroups(groupsFile, strains, groupNumbers);
        System.out.println("Group file analysed.");
        DrawGeneNumberCurve.calculateGeneNumbers(strains, geneNumbers, absoluteGeneNumbers, draws);
        DrawGeneNumberCurve.calculateGroupNumbers(strains, groupNumbers, numberOfGroups, draws);
    }

    public static void calculateGroupNumbers(ArrayList<String> strains, HashMap<String, HashMap<Integer, Boolean>> groupNumbers, File out, int draws) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int i = 0;
            while (i < strains.size()) {
                Stats s = DrawGeneNumberCurve.drawGroupNumbers(strains, groupNumbers, draws, i + 1);
                bw.write(String.valueOf(s.getAverage()) + "\t" + s.getStandardDeviation() + "\n");
                System.out.println("Average of " + (i + 1) + " genomes: " + s.getAverage() + " +- " + s.getStandardDeviation());
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void calculateGeneNumbers(ArrayList<String> strains, HashMap<String, Integer> geneNumbers, File out, int draws) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int i = 0;
            while (i < strains.size()) {
                Stats s = DrawGeneNumberCurve.drawGeneNumbers(strains, geneNumbers, draws, i + 1);
                bw.write(String.valueOf(s.getAverage()) + "\t" + s.getStandardDeviation() + "\n");
                System.out.println("Average of " + (i + 1) + " genomes: " + s.getAverage() + " +- " + s.getStandardDeviation());
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static ArrayList<Integer> makeArrayList(int size) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            temp.add(i);
            ++i;
        }
        return temp;
    }

    public static Stats drawGroupNumbers(ArrayList<String> strains, HashMap<String, HashMap<Integer, Boolean>> groupNumbers, int draws, int genomes) {
        ArrayList<Double> values = new ArrayList<Double>();
        int i = 0;
        while (i < draws) {
            HashMap groupHash = new HashMap();
            ArrayList<Integer> temp = DrawGeneNumberCurve.makeArrayList(strains.size());
            int j = 0;
            while (j < genomes) {
                int rand = (int)(Math.random() * (double)temp.size());
                groupHash.putAll(groupNumbers.get(strains.get(temp.get(rand))));
                temp.remove(rand);
                ++j;
            }
            values.add((double)groupHash.size() + 0.0);
            ++i;
        }
        return new Stats(values);
    }

    public static Stats drawGeneNumbers(ArrayList<String> strains, HashMap<String, Integer> geneNumbers, int draws, int genomes) {
        ArrayList<Double> values = new ArrayList<Double>();
        int i = 0;
        while (i < draws) {
            double value = 0.0;
            ArrayList<Integer> temp = DrawGeneNumberCurve.makeArrayList(strains.size());
            int j = 0;
            while (j < genomes) {
                int rand = (int)(Math.random() * (double)temp.size());
                value += (double)geneNumbers.get(strains.get(temp.get(rand))).intValue();
                temp.remove(rand);
                ++j;
            }
            values.add(value);
            ++i;
        }
        return new Stats(values);
    }

    public static String getStrainName(String gene) {
        StringBuffer strain = new StringBuffer();
        String[] split2 = gene.split("-");
        strain.append(split2[0]);
        int j = 1;
        while (j < split2.length - 1) {
            strain.append("-" + split2[j]);
            ++j;
        }
        return strain.toString();
    }

    public static void getGroups(File in, ArrayList<String> strains, HashMap<String, HashMap<Integer, Boolean>> groups) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(in));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\t");
                int group = Integer.parseInt(split[0]);
                int i = 1;
                while (i < split.length) {
                    String strain = DrawGeneNumberCurve.getStrainName(split[i]);
                    if (groups.containsKey(strain)) {
                        groups.get(strain).put(group, true);
                    } else {
                        HashMap<Integer, Boolean> temp = new HashMap<Integer, Boolean>();
                        temp.put(group, true);
                        groups.put(strain, temp);
                        strains.add(strain);
                    }
                    ++i;
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void getGeneNumbers(File groups, ArrayList<String> strains, HashMap<String, Integer> numbers) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(groups));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\t");
                int i = 1;
                while (i < split.length) {
                    String strain = DrawGeneNumberCurve.getStrainName(split[i]);
                    if (numbers.containsKey(strain)) {
                        numbers.put(strain, numbers.get(strain) + 1);
                    } else {
                        numbers.put(strain, 1);
                        strains.add(strain);
                    }
                    ++i;
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

