/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import util.DNAmanipulations;
import util.Fasta;
import util.Info;
import util.ReadGenbank;

public class ConvertGBKToFasta {
    public static void main(String[] args) {
        File gbk = new File(args[0]);
        int flank = Integer.parseInt(args[2]);
        File out = new File(args[3]);
        ConvertGBKToFasta.writeCDS(gbk, out, flank, true);
    }

    public static HashMap<String, Fasta> writeCDS(File gbk, File out, int flank, boolean DNA) {
        HashMap<String, Fasta> hm = new HashMap<String, Fasta>();
        try {
            if (!DNA) {
                flank = 0;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            ReadGenbank rgb = new ReadGenbank(gbk, "CDS");
            HashMap<String, String> genome = Fasta.fasToHash(rgb.getSequence(), false);
            ArrayList<String> ids = rgb.getIds();
            int count = 0;
            int j = 0;
            while (j < ids.size()) {
                String LocusId = ids.get(j);
                ArrayList<Info> CDS = rgb.getIntervals("CDS", LocusId);
                String seq = genome.get(LocusId);
                if (seq == null) {
                    System.err.println("Cannot find " + LocusId + " from genbank file " + gbk + " in corresponding sequence file!");
                    System.exit(-1);
                }
                String contig = genome.size() > 1 ? LocusId : "n/a";
                int i = 0;
                while (i < CDS.size()) {
                    String id = "" + (count + 1);
                    String description = String.valueOf(count + 1) + " " + CDS.get(i).getStart() + ".." + CDS.get(i).getEnd() + " " + CDS.get(i).getOrient() + " " + contig + " " + CDS.get(i).getInfo();
                    bw.write(">" + description + "\n");
                    String subseq = ConvertGBKToFasta.getDNASequence(CDS.get(i), flank, seq);
                    if (DNA) {
                        hm.put(id, new Fasta(description, subseq));
                        bw.write(String.valueOf(subseq) + "\n");
                    } else {
                        hm.put(id, new Fasta(description, DNAmanipulations.translate(subseq, DNAmanipulations.code())));
                        bw.write(String.valueOf(DNAmanipulations.translate(subseq, DNAmanipulations.code())) + "\n");
                    }
                    ++count;
                    ++i;
                }
                ++j;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return hm;
    }

    public static HashMap<String, Fasta> writeCDS(File gbk, ArrayList<Fasta> genome, File out, int flank, boolean DNA) {
        HashMap<String, Fasta> hm = new HashMap<String, Fasta>();
        try {
            if (!DNA) {
                flank = 0;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            ReadGenbank rgb = new ReadGenbank(gbk, new String[0]);
            int x = 0;
            int j = 0;
            while (j < genome.size()) {
                ArrayList<Info> CDS = rgb.getIntervals("CDS", genome.get(j).getIdent().split("\\s+|>")[0]);
                String seq = genome.get(j).getSequence();
                int i = 0;
                while (i < CDS.size()) {
                    String id = "" + ++x;
                    String description = String.valueOf(x) + " " + CDS.get(i).getStart() + ".." + CDS.get(i).getEnd() + " " + CDS.get(i).getOrient() + " " + out.getName().split("\\.")[0] + " " + CDS.get(i).getInfo();
                    bw.write(">" + description + "\n");
                    String subseq = ConvertGBKToFasta.getDNASequence(CDS.get(i), flank, seq);
                    if (DNA) {
                        hm.put(id, new Fasta(description, subseq));
                        bw.write(String.valueOf(subseq) + "\n");
                    } else {
                        hm.put(id, new Fasta(description, DNAmanipulations.translate(subseq, DNAmanipulations.code())));
                        bw.write(String.valueOf(DNAmanipulations.translate(subseq, DNAmanipulations.code())) + "\n");
                    }
                    ++i;
                }
                ++j;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return hm;
    }

    public static ArrayList<Fasta> getCDS(File gbk, ArrayList<Fasta> genome, int flank, boolean DNA) {
        ArrayList<Fasta> list = new ArrayList<Fasta>();
        if (!DNA) {
            flank = 0;
        }
        ReadGenbank rgb = new ReadGenbank(gbk, new String[0]);
        int x = 0;
        int j = 0;
        while (j < genome.size()) {
            String seq = genome.get(j).getSequence();
            String id = genome.get(j).getIdent().split(">|\\s+")[0];
            ArrayList<Info> CDS = rgb.getIntervals("CDS", id);
            int i = 0;
            while (i < CDS.size()) {
                String description = String.valueOf(++x) + " " + CDS.get(i).getStart() + ".." + CDS.get(i).getEnd() + " " + CDS.get(i).getOrient() + " " + CDS.get(i).getInfo();
                String subseq = ConvertGBKToFasta.getDNASequence(CDS.get(i), flank, seq);
                if (DNA) {
                    list.add(new Fasta(description, subseq));
                } else {
                    list.add(new Fasta(description, DNAmanipulations.translate(subseq, DNAmanipulations.code())));
                }
                ++i;
            }
            ++j;
        }
        return list;
    }

    public static String getDNASequence(Info inf, int flank, String seq) {
        boolean reverse = inf.info.endsWith("complement");
        int start = Math.min(inf.getStart() - 1, inf.getEnd()) - flank;
        int end = Math.max(inf.getStart() - 1, inf.getEnd()) + flank;
        String startAdd = "";
        String endAdd = "";
        if (start < 0) {
            startAdd = seq.substring(seq.length() + start);
            start = 0;
        }
        if (end > seq.length()) {
            endAdd = seq.substring(0, end - seq.length());
            end = seq.length() - 1;
        }
        String subseq = seq.substring(start, end);
        subseq = String.valueOf(startAdd) + subseq + endAdd;
        subseq = reverse ? DNAmanipulations.reverse(subseq) : subseq;
        return subseq;
    }
}

