/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import util.DNAmanipulations;

public class GenerateMutatedSequences {
    ArrayList<ArrayList<BitSet>> words = new ArrayList();

    public static void main(String[] args) {
        File out = new File(args[0]);
        int mutations = Integer.parseInt(args[1]);
        ArrayList<BitSet> words = new ArrayList<BitSet>();
        int i = 2;
        while (i < args.length) {
            words.add(DNAmanipulations.codeDNA(args[i]));
            ++i;
        }
        GenerateMutatedSequences gm = new GenerateMutatedSequences(words);
        int i2 = 0;
        while (i2 < mutations) {
            gm.mutateSequences();
            ++i2;
        }
        gm.write(out, mutations);
    }

    public GenerateMutatedSequences(ArrayList<BitSet> Words) {
        this.words.add(Words);
    }

    public GenerateMutatedSequences(ArrayList<BitSet> Words, int mut) {
        this.words.add(Words);
        int i = 1;
        while (i <= mut) {
            this.mutateSequences();
            ++i;
        }
    }

    public GenerateMutatedSequences(ArrayList<BitSet> Words, int mut, int notMut1, int notMut2) {
        this.words.add(Words);
        int i = 1;
        while (i <= mut) {
            this.mutateSequences(notMut1, notMut2);
            ++i;
        }
    }

    public void mutateSequences() {
        ArrayList<BitSet> newList = new ArrayList<BitSet>();
        int i = 0;
        while (i < this.words.get(this.words.size() - 1).size()) {
            newList.addAll(GenerateMutatedSequences.mutateSequence(this.words.get(this.words.size() - 1).get(i)));
            ++i;
        }
        newList.addAll((Collection)this.words.get(this.words.size() - 1));
        this.words.add(GenerateMutatedSequences.eliminateDoubles(newList));
    }

    public void mutateSequences(int notMut1, int notMut2) {
        ArrayList<BitSet> newList = new ArrayList<BitSet>();
        int i = 0;
        while (i < this.words.get(this.words.size() - 1).size()) {
            newList.addAll(GenerateMutatedSequences.mutateSequence(this.words.get(this.words.size() - 1).get(i), notMut1, notMut2));
            ++i;
        }
        newList.addAll((Collection)this.words.get(this.words.size() - 1));
        this.words.add(GenerateMutatedSequences.eliminateDoubles(newList));
    }

    private static ArrayList<BitSet> mutateSequence(BitSet seq, int notMut1, int notMut2) {
        ArrayList<BitSet> list = new ArrayList<BitSet>();
        int i = 0;
        while (i < seq.length() - 1) {
            if (i != notMut1 * 2 && i != notMut2 * 2) {
                int k = 0;
                while (k < 4) {
                    BitSet mut = DNAmanipulations.mutate(seq, i, k);
                    if (mut.length() > 0) {
                        list.add(mut);
                    }
                    ++k;
                }
            }
            i += 2;
        }
        return list;
    }

    private static ArrayList<BitSet> mutateSequence(BitSet seq) {
        ArrayList<BitSet> list = new ArrayList<BitSet>();
        int i = 0;
        while (i < seq.length() - 1) {
            int k = 0;
            while (k < 4) {
                BitSet mut = DNAmanipulations.mutate(seq, i, k);
                if (mut.length() > 0) {
                    list.add(mut);
                }
                ++k;
            }
            i += 2;
        }
        return list;
    }

    public void write(File out, int mut) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(out));
            int i = 0;
            while (i < this.words.get(mut).size()) {
                bw.write(">" + i + "\n" + DNAmanipulations.decodeDNA(this.words.get(mut).get(i)) + "\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public ArrayList<BitSet> getList(int mut) {
        return this.words.get(mut);
    }

    private static ArrayList<BitSet> eliminateDoubles(ArrayList<BitSet> words) {
        ArrayList<BitSet> newList = new ArrayList<BitSet>();
        HashMap<BitSet, Boolean> temp = new HashMap<BitSet, Boolean>();
        int i = 0;
        while (i < words.size()) {
            if (!temp.containsKey(DNAmanipulations.reverse(words.get(i)))) {
                temp.put(words.get(i), true);
            }
            ++i;
        }
        Iterator it = temp.keySet().iterator();
        while (it.hasNext()) {
            newList.add((BitSet)it.next());
        }
        return newList;
    }
}

