/*
 * Decompiled with CFR 0.152.
 */
package solexa;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import solexa.Arrays;
import util.DNAmanipulations;
import util.Fasta;
import util.Info;

public abstract class PointSubstitutions
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<Integer> alLength = new ArrayList();
    ArrayList<String> alName = new ArrayList();
    HashMap<String, HashMap<String, Integer>> substitutionInfo = new HashMap();
    HashMap<String, Arrays> bases;
    HashMap<String, double[]> substitutions;
    HashMap<String, double[]> coverage;
    HashMap<String, double[]> coveragePos;
    HashMap<String, double[]> coverageNeg;
    HashMap<String, HashMap<Integer, Integer>[]> baseNames;
    HashMap<String, String> fasta;
    HashMap<String, Double> avgCov = new HashMap();
    HashMap<String, Double> fractionCov = new HashMap();
    File alignmentFile;
    boolean subInfo = false;
    int flank;

    public PointSubstitutions(File RefSeq, int flank, File AlignmentFile, int quality, boolean subInfo) {
        this(RefSeq, flank, AlignmentFile, quality, 1, subInfo);
    }

    public PointSubstitutions(File RefSeq, int flank, File AlignmentFile, int quality, int fold, boolean subInfo) {
        this.flank = flank;
        this.fasta = this.readFasta(RefSeq);
        this.coverage = this.initCoverage();
        this.coveragePos = this.initCoverage();
        this.coverageNeg = this.initCoverage();
        this.baseNames = this.initNames();
        this.substitutions = this.initCoverage();
        this.bases = this.initBases(this.fasta);
        this.alignmentFile = AlignmentFile;
        this.subInfo = subInfo;
        this.read(quality, fold);
        int i = 0;
        while (i < this.alName.size()) {
            this.bases.get(this.alName.get(i)).setCoverage(this.coverage.get(this.alName.get(i)));
            ++i;
        }
        this.setAvgCoverage();
        this.setfractionCoverage();
    }

    abstract void read(int var1, int var2);

    public static ArrayList<Integer> getMismatchesRef(String mismatch) {
        String[] pos = mismatch.split("[^0-9]+");
        String[] edit = mismatch.split("[0-9]+");
        ArrayList<Integer> substitutionPos = new ArrayList<Integer>();
        int start = 0;
        int i = 1;
        while (i < pos.length) {
            start = start + Integer.parseInt(pos[i - 1]) + 1;
            if (edit[i].charAt(0) == '^') {
                start = start + edit[i].length() - 2;
            } else {
                substitutionPos.add(start);
            }
            ++i;
        }
        return substitutionPos;
    }

    public static ArrayList<Integer> getMismatchesRead(String mismatch) {
        String[] pos = mismatch.split("[^0-9]+");
        String[] edit = mismatch.split("[0-9]+");
        ArrayList<Integer> substitutionPos = new ArrayList<Integer>();
        int start = 0;
        int i = 1;
        while (i < pos.length) {
            start = start + Integer.parseInt(pos[i - 1]) + 1;
            if (edit[i].charAt(0) == '^') {
                --start;
            } else {
                substitutionPos.add(start);
            }
            ++i;
        }
        return substitutionPos;
    }

    public static ArrayList<Integer> getMismatchesRead(String mismatch, ArrayList<Integer> refDeletion) {
        String[] pos = mismatch.split("[^0-9]+");
        String[] edit = mismatch.split("[0-9]+");
        ArrayList<Integer> substitutionPos = new ArrayList<Integer>();
        int start = 0;
        int i = 1;
        while (i < pos.length) {
            start = start + Integer.parseInt(pos[i - 1]) + 1;
            if (edit[i].charAt(0) == '^') {
                --start;
            } else {
                substitutionPos.add(start);
            }
            ++i;
        }
        int refDelSize = refDeletion.size();
        int subPosSize = substitutionPos.size();
        int j = 0;
        int i2 = 0;
        while (i2 < refDelSize && j < subPosSize) {
            if (refDeletion.get(i2) <= substitutionPos.get(j)) {
                int k = j;
                while (k < subPosSize) {
                    substitutionPos.set(k, substitutionPos.get(k) + 1);
                    ++k;
                }
            } else {
                ++j;
                --i2;
            }
            ++i2;
        }
        return substitutionPos;
    }

    public static ArrayList<Integer> getRefDeletions(String cigar) {
        String[] distances = cigar.split("[^0-9]+");
        String[] editCodes = cigar.split("[0-9]+");
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int start = 0;
        int length = distances.length;
        int i = 1;
        while (i < length + 1) {
            if (!editCodes[i].equals("D") && !editCodes[i].equals("P")) {
                if (editCodes[i].equals("I")) {
                    int deletions = Integer.parseInt(distances[i - 1]);
                    int j = 0;
                    while (j < deletions) {
                        positions.add(++start);
                        ++j;
                    }
                } else {
                    start += Integer.parseInt(distances[i - 1]);
                }
            }
            ++i;
        }
        return positions;
    }

    public static void getMatchRegionsCigar(String cigar, StringBuffer read, StringBuffer ref) {
        String[] distances = cigar.split("[^0-9]+");
        String[] editCodes = cigar.split("[0-9]+");
        int i = 1;
        while (i < distances.length + 1) {
            int j;
            int dist = Integer.parseInt(distances[i - 1]);
            if (editCodes[i].equals("M")) {
                j = 0;
                while (j < dist) {
                    read.append('m');
                    ref.append('m');
                    ++j;
                }
            } else if (editCodes[i].equals("D")) {
                j = 0;
                while (j < dist) {
                    read.append('g');
                    ref.append('m');
                    ++j;
                }
            } else if (editCodes[i].equals("I")) {
                j = 0;
                while (j < dist) {
                    read.append('m');
                    ref.append('g');
                    ++j;
                }
            }
            ++i;
        }
    }

    public HashMap<String, Arrays> getBases() {
        return this.bases;
    }

    public Arrays getBases(String id) {
        return this.bases.get(id);
    }

    public HashMap<String, double[]> getCoverage() {
        return this.coverage;
    }

    public HashMap<String, double[]> getCoveragePos() {
        return this.coveragePos;
    }

    public HashMap<String, double[]> getCoverageNeg() {
        return this.coverageNeg;
    }

    public double[] getCoverage(String id) {
        return this.coverage.get(id);
    }

    public double[] getCoveragePos(String id) {
        return this.coveragePos.get(id);
    }

    public double[] getCoverageNeg(String id) {
        return this.coverageNeg.get(id);
    }

    public String getGene(String id) {
        return this.fasta.get(id);
    }

    public HashMap<String, HashMap<Integer, Integer>[]> getBaseNames() {
        return this.baseNames;
    }

    public HashMap<Integer, Integer> getBaseName(String id, int pos) {
        return this.baseNames.get(id)[pos];
    }

    public boolean checkfractionCoverage(String id, double t) {
        return this.fractionCov.get(id) > t;
    }

    public double getfractionCoverage(String id) {
        return this.fractionCov.get(id);
    }

    public boolean checkAvgCoverage(String id, double t) {
        return this.avgCov.get(id) > t;
    }

    public void setAvgCoverage() {
        int i = 0;
        while (i < this.alName.size()) {
            int sum = 0;
            int j = 0;
            while (j < this.alLength.get(i)) {
                sum = (int)((double)sum + this.coverage.get(this.alName.get(i))[j]);
                ++j;
            }
            this.avgCov.put(this.alName.get(i), (double)sum / ((double)this.alLength.get(i).intValue() * 1.0));
            ++i;
        }
    }

    public void setfractionCoverage() {
        int i = 0;
        while (i < this.alName.size()) {
            int sum = 0;
            int j = 0;
            while (j < this.alLength.get(i)) {
                if (this.coverage.get(this.alName.get(i))[j] > 0.0) {
                    ++sum;
                }
                ++j;
            }
            this.fractionCov.put(this.alName.get(i), (double)sum / ((double)this.alLength.get(i).intValue() * 1.0));
            ++i;
        }
    }

    public HashMap<String, String> readFasta(File in) {
        ArrayList<Fasta> fas = Fasta.readFasta(in);
        HashMap<String, String> hm = Fasta.fasToHash(fas, false);
        int size = fas.size();
        int i = 0;
        while (i < size) {
            Fasta fasta = fas.get(i);
            this.alName.add(fasta.getIdent().split("\\s+")[0]);
            this.alLength.add(fasta.getSequence().length() - 2 * this.flank);
            ++i;
        }
        return hm;
    }

    public HashMap<String, Arrays> initBases(HashMap<String, String> refs) {
        HashMap<String, Arrays> bases = new HashMap<String, Arrays>();
        int i = 0;
        while (i < this.alLength.size()) {
            String ref = refs.get(this.alName.get(i));
            ref = ref.substring(this.flank, ref.length() - this.flank);
            bases.put(this.alName.get(i), new Arrays(ref));
            ++i;
        }
        return bases;
    }

    public HashMap<String, HashMap<Integer, Integer>[]> initNames() {
        HashMap<String, HashMap<Integer, Integer>[]> baseNames = new HashMap<String, HashMap<Integer, Integer>[]>();
        int i = 0;
        while (i < this.alName.size()) {
            baseNames.put(this.alName.get(i), new HashMap[this.alLength.get(i) + 1]);
            ++i;
        }
        return baseNames;
    }

    public HashMap<String, double[]> initCoverage() {
        HashMap<String, double[]> coverage = new HashMap<String, double[]>();
        int i = 0;
        while (i < this.alName.size()) {
            coverage.put(this.alName.get(i), new double[this.alLength.get(i) + 1]);
            ++i;
        }
        return coverage;
    }

    private double initWindowCount(ArrayList<Double> countArray, int stepsize, int covWindowSize) {
        double count = 0.0;
        int i = 0;
        while (i < covWindowSize / stepsize && i < countArray.size()) {
            count += countArray.get(i).doubleValue();
            ++i;
        }
        return count;
    }

    private void addArea(int start, int end, ArrayList<Info> areas) {
        if (areas.size() == 0) {
            Info temp = new Info(start, end, "");
            areas.add(temp);
        } else {
            Info previous = areas.get(areas.size() - 1);
            if (previous.getEnd() >= start) {
                Info temp = new Info(previous.getStart(), end, "");
                areas.remove(areas.size() - 1);
                areas.add(temp);
            } else {
                Info temp = new Info(start, end, "");
                areas.add(temp);
            }
        }
    }

    private ArrayList<Double> getCountArray(int stepSize, double[] cov) {
        ArrayList<Double> countArray = new ArrayList<Double>();
        double count = 0.0;
        int i = 0;
        while (i < cov.length) {
            count += (double)(cov[i] > 0.0 ? 1 : 0);
            if ((i + 1) % 10 == 0) {
                countArray.add(count);
                count = 0.0;
            }
            ++i;
        }
        return countArray;
    }

    public void writeArray(double threshold, File refseq, File outDir) {
        try {
            BufferedWriter bwCov = new BufferedWriter(new FileWriter(new File(outDir + "/coverage.out")));
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outDir + "/" + refseq.getName() + ".out")));
            int occ = 0;
            int changes = 0;
            bw.write("Pos\tcov\torigF\tF\tA\tT\tG\tC\tR\tA\tT\tG\tC\t-R\t-F\n");
            int i = 0;
            while (i < this.alName.size()) {
                String gene = this.fasta.get(this.alName.get(i));
                Arrays geneBases = this.bases.get(this.alName.get(i));
                double[] geneCoverage = this.coverage.get(this.alName.get(i));
                int cov = 0;
                int j = 1;
                while (j < geneBases.length - 1 - 2 * this.flank) {
                    cov = (int)((double)cov + geneCoverage[j]);
                    if (geneBases.numBases(j) / (geneCoverage[j] * 1.0) > threshold && geneCoverage[j] > 0.0) {
                        ++occ;
                        bw.write(String.valueOf(geneBases.numBases(j)) + "\t" + this.alName.get(i) + "\t" + j + "\t" + PointSubstitutions.round(geneCoverage[j], 1) + "\t" + gene.charAt(j - 1 + this.flank) + "\t\t" + PointSubstitutions.round(geneBases.get(j, "AF"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "TF"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "GF"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "CF"), 1) + "\t\t" + PointSubstitutions.round(geneBases.get(j, "AR"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "TR"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "GR"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "CR"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "-R"), 1) + "\t" + PointSubstitutions.round(geneBases.get(j, "-F"), 1) + "\t");
                        bw.write("\n");
                    }
                    ++j;
                }
                bwCov.write(String.valueOf(this.alName.get(i)) + "\t" + (double)cov / ((double)geneBases.length * 1.0) + "\n");
                ++i;
            }
            BufferedWriter stat = new BufferedWriter(new FileWriter(outDir + "/stats.out"));
            stat.write("Occurrences: " + occ + "\nCaused nucleotide changes in genes: " + changes);
            stat.close();
            bw.close();
            bwCov.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static double round(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        int power = n;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public ArrayList<Info> getCoveredAreas(String id, double fractionCov, int covWindow) {
        int stepsize = 10;
        double[] cov = this.coverage.get(id);
        if (cov.length > covWindow) {
            ArrayList<Info> areas = new ArrayList<Info>();
            ArrayList<Double> countArray = this.getCountArray(stepsize, cov);
            double windowCount = this.initWindowCount(countArray, stepsize, covWindow);
            int start = covWindow / stepsize;
            if (windowCount / ((double)covWindow * 1.0) >= fractionCov) {
                this.addArea(0, covWindow, areas);
            }
            int i = 0;
            while (i < countArray.size() - start) {
                double subtract = countArray.get(i);
                double add = countArray.get(i + start);
                double fraction = (windowCount = windowCount + add - subtract) / ((double)covWindow * 1.0);
                if (fraction >= fractionCov) {
                    this.addArea(i * stepsize, i * stepsize + covWindow, areas);
                }
                ++i;
            }
            return areas;
        }
        if (this.getfractionCoverage(id) >= fractionCov) {
            ArrayList<Info> wholeArea = new ArrayList<Info>();
            wholeArea.add(new Info(0, cov.length, ""));
            return wholeArea;
        }
        return new ArrayList<Info>();
    }

    int getQueryName(String readID, int subpos, char orientation, int length) {
        int readIDPos = Integer.parseInt(readID);
        subpos = orientation == '+' ? subpos : length - (subpos + 1);
        int position = subpos + readIDPos;
        return position;
    }

    String getStrain(String[] readIDsplit) {
        StringBuffer strain = new StringBuffer();
        strain.append(readIDsplit[0]);
        int i = 1;
        while (i < readIDsplit.length - 1) {
            strain.append("_" + readIDsplit[i]);
            ++i;
        }
        return strain.toString();
    }

    public HashMap<String, Integer> getSubstitutionInfo(String refID) {
        return this.substitutionInfo.get(refID);
    }

    public int getMappedSites(int minCov) {
        int sum = 0;
        Iterator<Map.Entry<String, double[]>> it = this.coverage.entrySet().iterator();
        while (it.hasNext()) {
            double[] cov = it.next().getValue();
            int i = 0;
            while (i < cov.length) {
                if (cov[i] >= (double)minCov) {
                    ++sum;
                }
                ++i;
            }
        }
        return sum;
    }

    double setSubstitution(String readSequence, int mismatchRead, int mismatchRef, String readID, String qualityString, char orientation, int posorig, int quality, String geneId, boolean subInfo, double weight) {
        int lengthSeq = this.substitutions.get(geneId).length;
        int sub = posorig + mismatchRef - this.flank;
        double ret = 0.0;
        if (sub > 0 && sub < lengthSeq && qualityString.charAt(mismatchRead) - 33 >= quality) {
            String base;
            String string = base = orientation == '+' ? String.valueOf(readSequence.charAt(mismatchRead)) + "F" : String.valueOf(DNAmanipulations.reverse(String.valueOf(readSequence.charAt(mismatchRead)))) + "R";
            if (lengthSeq > sub) {
                double[] dArray = this.substitutions.get(geneId);
                int n = sub;
                dArray[n] = dArray[n] + weight;
                if (!subInfo) {
                    this.bases.get(geneId).set(sub, base, weight, readSequence);
                } else {
                    int length = readSequence.length();
                    if (!this.bases.get(geneId).isset(sub)) {
                        int subID = this.getQueryName(readID, mismatchRead, orientation, length);
                        this.bases.get(geneId).set(sub, base, subID, weight, readSequence);
                        if (sub == 9528) {
                            ret = weight;
                        }
                    } else {
                        this.bases.get(geneId).set(sub, base, weight, readSequence);
                    }
                }
            }
        }
        return ret;
    }

    void setGap(String readSequence, int mismatchRead, int mismatchRef, String readID, char orientation, int posorig, String fastaId, boolean subInfo, double weight) {
        int lengthSeq = this.substitutions.get(fastaId).length;
        int sub = posorig + mismatchRef - this.flank;
        if (sub > 0 && sub < lengthSeq) {
            String base;
            String string = base = orientation == '+' ? "-F" : "-R";
            if (lengthSeq > sub) {
                double[] dArray = this.substitutions.get(fastaId);
                int n = sub;
                dArray[n] = dArray[n] + weight;
                if (!subInfo) {
                    this.bases.get(fastaId).set(sub, base, weight, "");
                } else {
                    int length = readSequence.length();
                    if (!this.bases.get(fastaId).isset(sub)) {
                        int subID = this.getQueryName(readID, mismatchRead, orientation, length);
                        this.bases.get(fastaId).set(sub, base, subID, weight, readSequence);
                    } else {
                        this.bases.get(fastaId).set(sub, base, weight, "");
                    }
                }
            }
        }
    }

    double setCoverage(int pos, int length, String fastaId, String sequence, String qualityString, int quality, char orientation, boolean subInfo, String readID, double weight) {
        double ret = 0.0;
        int lengthSeq = this.coverage.get(fastaId).length;
        double[] cov = this.coverage.get(fastaId);
        double[] covPos = this.coveragePos.get(fastaId);
        double[] covNeg = this.coverageNeg.get(fastaId);
        int i = pos;
        while (i < pos + length && i < lengthSeq) {
            int subpos = i - pos;
            if (i > 0 && lengthSeq > i && qualityString.charAt(subpos) - 33 >= quality) {
                int n = i;
                cov[n] = cov[n] + weight;
                if (i == 9528) {
                    ret = weight;
                }
                if (orientation == '+') {
                    int n2 = i;
                    covPos[n2] = covPos[n2] + weight;
                } else {
                    int n3 = i;
                    covNeg[n3] = covNeg[n3] + weight;
                }
            }
            if (subInfo) {
                this.addBaseNames(fastaId, i, readID, subpos, orientation, length);
            }
            ++i;
        }
        return ret;
    }

    void setCoverageSingle(int pos, int readPos, String fastaId, String sequence, String qualityString, int quality, char orientation, boolean subInfo, String readID, double weight, boolean gap) {
        int lengthSeq = this.coverage.get(fastaId).length;
        double[] cov = this.coverage.get(fastaId);
        double[] covPos = this.coveragePos.get(fastaId);
        double[] covNeg = this.coverageNeg.get(fastaId);
        int subpos = readPos;
        int sub = pos - this.flank;
        if (sub >= 0 && lengthSeq > sub && qualityString.charAt(subpos) - 33 >= quality) {
            int n = sub;
            cov[n] = cov[n] + weight;
            if (orientation == '+') {
                int n2 = sub;
                covPos[n2] = covPos[n2] + weight;
            } else {
                int n3 = sub;
                covNeg[n3] = covNeg[n3] + weight;
            }
            if (subInfo && !gap) {
                this.addBaseNames(fastaId, sub, readID, subpos, orientation, qualityString.length());
            }
        }
    }

    void addBaseNames(String fastaId, int sub, String readID, int subpos, char orientation, int length) {
        int subID = this.getQueryName(readID, subpos, orientation, length);
        if (this.baseNames.get(fastaId)[sub] == null) {
            HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
            temp.put(subID, 1);
            this.baseNames.get((Object)fastaId)[sub] = temp;
        } else if (this.baseNames.get(fastaId)[sub].containsKey(subID)) {
            int item = this.baseNames.get(fastaId)[sub].get(subID);
            this.baseNames.get(fastaId)[sub].put(subID, ++item);
        }
    }
}

