/*
 * Decompiled with CFR 0.152.
 */
package buildTreesFromSequenceData;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public final class SamplingBiasParameters {
    ArrayList<Integer> seqLength = new ArrayList();
    ArrayList<Double> A = new ArrayList();
    ArrayList<Double> B = new ArrayList();

    public SamplingBiasParameters() {
        this.readParameters();
    }

    public void readParameters() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/resources/parameters.txt")));
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\\s+");
                this.seqLength.add(Integer.parseInt(split[0]));
                this.A.add(Double.parseDouble(split[1]));
                this.B.add(Double.parseDouble(split[2]));
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public double getA(int seqlength) {
        int i = 0;
        while (i < this.seqLength.size()) {
            if (seqlength <= this.seqLength.get(i)) {
                return this.A.get(i);
            }
            ++i;
        }
        return this.A.get(this.A.size() - 1);
    }

    public double getB(int seqlength) {
        int i = 0;
        while (i < this.seqLength.size()) {
            if (seqlength <= this.seqLength.get(i)) {
                return this.B.get(i);
            }
            ++i;
        }
        return this.B.get(this.B.size() - 1);
    }
}

